/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

#pragma once

#include <stdint.h>
#include <string>

namespace proxygen {

namespace HTTP3 {
enum ErrorCode : uint16_t {
  // HTTP/3 error codes from draft
  HTTP_NO_ERROR = 0x100,
  HTTP_GENERAL_PROTOCOL_ERROR = 0x101,
  HTTP_INTERNAL_ERROR = 0x102,
  HTTP_STREAM_CREATION_ERROR = 0x103,
  HTTP_CLOSED_CRITICAL_STREAM = 0x104,
  HTTP_FRAME_UNEXPECTED = 0x105,
  HTTP_FRAME_ERROR = 0x106,
  HTTP_EXCESSIVE_LOAD = 0x107,
  HTTP_ID_ERROR = 0x108, // TODO: needs to audit the lack of use of this error.
  HTTP_SETTINGS_ERROR = 0x109,
  HTTP_MISSING_SETTINGS = 0x10A,
  HTTP_REQUEST_REJECTED = 0x10B,
  HTTP_REQUEST_CANCELLED = 0x10C,
  HTTP_INCOMPLETE_REQUEST = 0x10D,
  HTTP_CONNECT_ERROR = 0x10F,
  HTTP_VERSION_FALLBACK = 0x110,
  // TODO: Homemade and legacy error code that should be audited:
  HTTP_PUSH_REFUSED = 0x02,
  HTTP_PUSH_ALREADY_IN_CACHE = 0x04,
  HTTP_WRONG_STREAM = 0x0A,
  HTTP_UNKNOWN_STREAM_TYPE = 0x0D,
  HTTP_WRONG_STREAM_COUNT = 0x0E,
  // QPACK 0x200, all from draft
  HTTP_QPACK_DECOMPRESSION_FAILED = 0x200,
  HTTP_QPACK_ENCODER_STREAM_ERROR = 0x201,
  HTTP_QPACK_DECODER_STREAM_ERROR = 0x202,

  // Internal use only
  GIVEUP_ZERO_RTT = 0xF2
};
}
std::string toString(HTTP3::ErrorCode code);

} // namespace proxygen
