# Pipelines

For more details on rtransfer classes please see inline docs in headers.

## Client

### Control pipeline

[`wangle::AsyncSocketHandler`](https://github.com/facebook/wangle/blob/master/wangle/channel/AsyncSocketHandler.h)<br/>
[`wangle::OutputBufferingHandler`](https://github.com/facebook/wangle/blob/master/wangle/channel/OutputBufferingHandler.h) <br/>
`rtransfer::EventBaseHandler` - ensures writes happen in the socket's thread<br/>
`rtransfer::HttpResponseHandler` - reads HTTP response<br/>
`rtransfer::PeerSecretHandler` - reads and validates peer secret<br/>
`rtransfer::CtrlIdHandler` - reads `00` and ctrlId<br/>
`rtransfer::ConnectionCloseHandler` - shared handler to close link once one conn closes<br/>
[`wangle::LengthFieldBasedFrameDecoder`](https://github.com/facebook/wangle/blob/master/wangle/codec/LengthFieldBasedFrameDecoder.h) - splits input stream by 2-byte size header<br/>
[`wangle::LengthFieldPrepender`](https://github.com/facebook/wangle/blob/master/wangle/codec/LengthFieldPrepender.h) - adds 2-byte size header to output messages<br/>
`rtransfer::ProtoHandler` - encodes and decodes bytes into protobuf messages

After a handshake is complete (as described in the protocol doc), `rtransfer::HttpResponseHandler`, `rtransfer::PeerSecretHandler` and `rtransfer::CtrlIdHandler` are removed from the pipeline.

### Data pipeline

[`wangle::AsyncSocketHandler`](https://github.com/facebook/wangle/blob/master/wangle/channel/AsyncSocketHandler.h)<br/>
`rtransfer::EventBaseHandler` - ensures writes happen in the socket's thread<br/>
`rtransfer::HttpResponseHandler` - reads HTTP response<br/>
`rtransfer::PeerSecretHandler` - reads and validates peer secret<br/>
`rtransfer::PingSender` - sends some bytes every 10 seconds<br/>
`rtransfer::ConnectionCloseHandler` - shared handler to close link once one conn closes<br/>
[`wangle::LengthFieldBasedFrameDecoder`](https://github.com/facebook/wangle/blob/master/wangle/codec/LengthFieldBasedFrameDecoder.h) - splits input stream by 4-byte size field in header<br/>
`rtransfer::FetchManager` - handles incoming fetch data, see doc

As with a client pipeline, after a handshake is complete `rtransfer::HttpResponseHandler` and `rtransfer::PeerSecretHandler` are both removed from the pipeline.

## Server

### Common

`rtransfer::RoutingDataHandler` - determines whether a connection is a ctrl or data one, and sets up other pipeline handlers after it does so. It is removed after its job is done.

### Control pipeline

`rtransfer::EventBaseHandler` - ensures writes happen in the socket's thread<br/>
`rtransfer::ControlHandler` - manages its own pipeline and acts as a proxy between *this* pipeline and the managed one

#### `rtransfer::ControlHandler`'s pipeline

`rtransfer::ControlHandler` - the handler managing *this* pipeline<br/>
[`wangle::LengthFieldBasedFrameDecoder`](https://github.com/facebook/wangle/blob/master/wangle/codec/LengthFieldBasedFrameDecoder.h) - splits input stream by 2-byte size header<br/>
[`wangle::LengthFieldPrepender`](https://github.com/facebook/wangle/blob/master/wangle/codec/LengthFieldPrepender.h) - adds 2-byte size header to output messages
`rtransfer::ProtoHandler` - encodes and decodes bytes into protobuf messages<br/>
`rtransfer::ServerSideLink` - represents a "link", ie *this* and data pipelines<br/>
[`wangle::MultiplexServerDispatcher`](https://github.com/facebook/wangle/blob/master/wangle/service/ServerDispatcher.h) - dispatches to `rtransfer::Service`

### Data pipeline

`rtransfer::PingReceiver` - receives bytes sent by `rtransfer::PingSender`<br/>
[`wangle::OutputBufferingHandler`](https://github.com/facebook/wangle/blob/master/wangle/channel/OutputBufferingHandler.h) <br/>
`rtransfer::DataConn` - created by `rtransfer::ServerSideLinkFactory`, registers *this* with `rtransfer::ServerSideLink`<br/>
`rtransfer::EventBaseHandler` - ensures writes happen in the socket's thread
