#pragma once

#include "controlService.hpp"
#include "periodicHandler.hpp"

#include <folly/executors/SerialExecutor.h>
#include <folly/futures/Future.h>
#include <folly/futures/SharedPromise.h>

#include <queue>
#include <unordered_map>

namespace rtransfer {

class AuthCache {
public:
    AuthCache(link_control::ControlService &controlService);

    folly::Future<std::shared_ptr<link_control::proto::Request>> authorize(
        folly::fbstring providerId, folly::fbstring transferData);

private:
    using Key = std::pair<folly::fbstring, folly::fbstring>;
    using Promise =
        folly::SharedPromise<std::shared_ptr<link_control::proto::Request>>;

    struct ExpNode {
        Key key;
        std::chrono::steady_clock::time_point addTimePoint;
    };

    folly::Future<std::shared_ptr<link_control::proto::Request>> doAuthorize(
        folly::fbstring providerId, folly::fbstring transferData);

    std::shared_ptr<Promise> authorizeWithServer(Key key);

    void trigger();
    void doTrigger();

    folly::SerialExecutor executor_;
    std::unordered_map<Key, std::shared_ptr<Promise>> responses_;
    std::queue<ExpNode> expirations_;

    link_control::ControlService &controlService_;
    PeriodicHandler periodicHandler_;
};

}  // namespace rtransfer
