#pragma once

#include <helpers/storageHelper.h>

#include <cstdint>
#include <queue>
#include <unordered_map>
#include <utility>

namespace rtransfer {

template <typename T>
class ChainQueue {
    using Offset = std::size_t;
    using Handle = one::helpers::FileHandle *;
    using Key = std::pair<Offset, Handle>;

public:
    using value_type = T;

    folly::fbvector<T> pop()
    {
        DCHECK(reqs_.empty() >= order_.empty());

        folly::fbvector<T> res;
        if (reqs_.empty())
            return res;

        auto it = reqs_.end();
        while (it == reqs_.end()) {
            it = reqs_.find(order_.front());
            order_.pop();
        }

        while (it != reqs_.end()) {
            res.emplace_back(std::move(it->second));
            reqs_.erase(it);
            it = reqs_.find(makeNextKey(res.back()));
        }

        return res;
    }

    void push(T val)
    {
        auto key = makeKey(val);
        reqs_.emplace(key, std::move(val));
        order_.emplace(std::move(key));
    }

private:
    Key makeKey(const T &val) const { return {val.offset, val.handle.get()}; }
    Key makeNextKey(const T &val) const
    {
        return {val.offset + val.getSize(), val.handle.get()};
    }

    std::unordered_multimap<Key, T> reqs_;
    std::queue<Key> order_;
};

}  // namespace rtransfer
