#pragma once

#include <wangle/channel/Handler.h>

namespace rtransfer {

class EventBaseHandler : public wangle::OutboundBytesToBytesHandler {
public:
    folly::Future<folly::Unit> write(
        Context* ctx, std::unique_ptr<folly::IOBuf> buf) override
    {
        return via(ctx->getTransport()->getEventBase()).then([
            ctx, buf = std::move(buf)
        ]() mutable { return ctx->fireWrite(std::move(buf)); });
    }

    folly::Future<folly::Unit> close(Context* ctx) override
    {
        return via(ctx->getTransport()->getEventBase()).then([ctx] {
            return ctx->fireClose();
        });
    }
};

}  // namespace rtransfer
