#pragma once

#include "common.hpp"
#include "proto/rtransfer_messages.pb.h"

#include <folly/FBString.h>
#include <folly/FBVector.h>
#include <folly/Random.h>
#include <folly/SpinLock.h>
#include <folly/concurrency/ConcurrentHashMap.h>
#include <glog/logging.h>
#include <wangle/channel/Handler.h>
#include <wangle/channel/Pipeline.h>

#include <sys/ioctl.h>

#include <algorithm>

namespace rtransfer {

class DataConn;

class ServerSideLink
    : public wangle::HandlerAdapter<std::unique_ptr<proto::LinkMessage>> {
public:
    using Conn = std::pair<wangle::DefaultPipeline::Ptr, wangle::TransportInfo>;

    ServerSideLink(std::string peerAddr);

    std::string getPeerAddr();

    void attachPipeline(Context *ctx) override;

    void addDataConnection(wangle::DefaultPipeline::Ptr pipeline);

    void removeDataConnection(wangle::DefaultPipeline::Ptr pipeline);

    folly::fbvector<Conn> dataConnections(
        std::chrono::steady_clock::time_point now);

    void readEOF(Context *ctx) override;

private:
    void maybeProbe(std::chrono::steady_clock::time_point now);
    wangle::TransportInfo probe(wangle::DefaultPipeline::Ptr conn);

    std::string peerAddr_;
    Context *ctrlCtx_ = nullptr;
    folly::fbvector<Conn> dataConns_;
    folly::SpinLock lock_;

    std::chrono::steady_clock::time_point lastProbe_;
};

class DataConn : public wangle::HandlerAdapter<folly::IOBufQueue &,
                     std::unique_ptr<folly::IOBuf>> {
public:
    DataConn(std::shared_ptr<ServerSideLink> link);

    void attachPipeline(Context *ctx) override;

    void readEOF(Context *ctx) override;

private:
    wangle::DefaultPipeline::Ptr getPipeline(Context *ctx);

    std::shared_ptr<ServerSideLink> link_;
};

class ServerSideLinkFactory {
public:
    ServerSideLinkFactory(
        folly::ConcurrentHashMap<folly::fbstring, std::weak_ptr<ServerSideLink>>
            &map);

    std::shared_ptr<ServerSideLink> operator()(
        folly::StringPiece ctrlId, std::string peerAddr);

    std::shared_ptr<DataConn> createDataConn(const folly::fbstring &ctrlId);

private:
    folly::ConcurrentHashMap<folly::fbstring, std::weak_ptr<ServerSideLink>>
        &map_;
};

}  // namespace rtransfer
