import socket
import sys
import pytest
import random
import json
import subprocess
import hashlib
import time
import uuid
import base64
import tempfile
import os
from multiprocessing import Pool

class RTransfer(object):
    def __init__(self, server_port):
        self.server_port = server_port

    def run(self):
        self.process = subprocess.Popen(["build/link", "--v=2",
                                         "-server_port", str(self.server_port)],
                                        stdin=subprocess.PIPE, stdout=subprocess.PIPE)

    def request_async(self, req):
        # print 'req: ', req
        self.process.stdin.write(json.dumps(req) + "\n")

    def get_response(self):
        resp = {"isUpdate": True}
        while resp.get("isUpdate"):
            line = self.process.stdout.readline()
            resp = json.loads(line)
            # print 'resp: ', resp
        return resp

    def request(self, req):
        self.request_async(req)
        resp = self.get_response()
        return resp

    def stop(self):
        (output, err) = self.process.communicate()
        print "output", output
        print "err", err

def start_rtransfer(server_port):
    rtransfer = RTransfer(server_port)
    rtransfer.run()
    return rtransfer

@pytest.fixture()
def rtransfer(request):
    p1 = start_rtransfer(2345)
    p2 = start_rtransfer(2346)
    def fin():
        p1.stop()
        p2.stop()
    request.addfinalizer(fin)
    time.sleep(5)
    return (p1, p2)

def create_helper(prov, root, slow=False):
    storage_id = base64.b64encode(uuid.uuid4().bytes)
    params = [{'key': 'latencyMin', 'value': base64.b64encode("100")},
              {'key': 'latencyMax', 'value': base64.b64encode("200")}] if slow else []
    req = {"create_helper": {"storage_id": storage_id, "name": "nulldevice",
                             "params": params,
                             "io_buffered": False}}
    assert {"done": True} == prov.request(req)
    return storage_id

def connect(prov_from, prov_to):
    p1secret = base64.b64encode("a"*64)
    p2secret = base64.b64encode("b"*64)
    allow_req = {"allow_connection": {"my_secret": p2secret,
                                      "peer_secret": p1secret,
                                      "provider_id": base64.b64encode("otherprovider"),
                                      "expiration": 60000}}
    assert {"done": True} == prov_to.request(allow_req)

    req = {"connect": {"my_secret": p1secret, "peer_secret": p2secret,
                       "peer_host": "127.0.0.1", "peer_port": prov_to.server_port}}
    resp = prov_from.request(req)
    assert "connectionId" in resp
    return resp["connectionId"]

def do_open(prov, conn_id, storage_id):
    filename = str(random.random())
    file_id = base64.b64encode("/" + filename)
    # req = {"open": {"storage_id": storage_id, "file_id": file_id}}
    # if conn_id:
    #     req["open"]["connection_id"] = conn_id
    # resp = prov.request(req)
    # assert "fd" in resp
    return file_id

def do_fetch(prov, prov_from, conn_id, src_storage_id, src_fd, dest_storage_id,
             dest_fd, offset, size, priority = 1):
    req = {"fetch": {"connection_id": conn_id, "src_storage_id": src_storage_id,
                     "src_file_id": src_fd, "dest_storage_id": dest_storage_id, "dest_file_id": dest_fd,
                     "offset": offset, "size": size, "req_id": int(random.uniform(0, 2**63)),
                     "priority": priority}}

    prov.request_async(req)

    question = prov_from.get_response()
    assert question["isQuestion"] == True
    resp = {"req_id": question["reqId"], "is_answer": True,
            "auth_response": {"is_authorized": True}}

    prov_from.request_async(resp)

def md5(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
            return hash_md5.hexdigest()

def doit(p1, p2, dest_storage_id, src_storage_id, conn_id):
    num = 100
    size = 10*1024*1024
    for i in xrange(0, num):
        destfd = do_open(p1, None, dest_storage_id)
        srcfd = do_open(p1, conn_id, src_storage_id)
        for j in xrange(0, num):
            priority = 1 if i < num-1 else 0
            do_fetch(p1, p2, conn_id, src_storage_id, srcfd, dest_storage_id,
                     destfd, j * size, size, priority)

    for i in xrange(0, num*num):
        assert {"wrote": str(size)} == p1.get_response()
        print i

def test(rtransfer):
    (p1, p2) = rtransfer
    dest_storage_id = create_helper(p1, "/tmp", slow=False)
    src_storage_id = create_helper(p2, "/tmp")
    conns = [connect(p1, p2) for _ in xrange(0, 10)]

    print "now"
    raw_input()

    for conn_id in conns:
        doit(p1, p2, dest_storage_id, src_storage_id, conn_id)
