%%%--------------------------------------------------------------------
%%% @author Tomasz Lichon
%%% @copyright (C) 2015 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%--------------------------------------------------------------------
%%% @doc
%%% Errors produced by storage files manager.
%%% @end
%%%--------------------------------------------------------------------
-ifndef(STORAGE_FILES_MANAGER_ERRORS_HRL).
-define(STORAGE_FILES_MANAGER_ERRORS_HRL, 1).

% Errors generated by storage_file_manager.
% Errors that occur in storage_file_manager should all be reported as one type of error.
-define(SFM_ERROR, filesystem_error).

% This define contains list of error ID and message pairs.
% ErrorMessage should be a human-readable string.
-define(ERROR_DESCRIPTIONS, [
    {?SFM_ERROR, <<"An error occured in underlying file system.">>}
]).

-endif.