# DownloadLcbDeb(url location)
FIND_PROGRAM(WGET wget)
FIND_PROGRAM(CURL curl)
MACRO(DOWNLOAD_LCB_DEP url dest)
    IF(WIN32)
        EXECUTE_PROCESS(COMMAND powershell -Command
            "(New-Object Net.WebClient).DownloadFile('${url}', '${dest}')" RESULT_VARIABLE DLRC)
    ELSEIF(CURL)
        EXECUTE_PROCESS(COMMAND "${CURL}" "${url}" -o "${dest}" RESULT_VARIABLE DLRC)
    ELSEIF(WGET)
        EXECUTE_PROCESS(COMMAND "${WGET}" "${url}" -O "${dest}" RESULT_VARIABLE DLRC)
    ELSE()
        MESSAGE(WARNING "Using buggy built-in CMake downloader")
        FILE(DOWNLOAD ${url} ${dest} INACTIVITY_TIMEOUT 30 SHOW_PROGRESS)
        SET(DLRC 0)
    ENDIF()
    IF(NOT DLRC EQUAL 0)
        MESSAGE(FATAL_ERROR "Failed to download ${url}")
    ENDIF()
ENDMACRO()
