import os
import sys
import subprocess
import json

provider = sys.argv[1]
space = sys.argv[2]
token = sys.argv[3]
directory = sys.argv[4]

studies_dir = 'studies'
data_object_dir = 'data_objects'

FNULL = open(os.devnull, 'w')

curl = [
  'curl',
  '-k',
  '-H', 'X-Auth-Token: ' + token,
  '-H', 'X-CDMI-Specification-Version: 1.1.1',
  '-H', 'Content-Type: application/cdmi-container',
  '-X', 'DELETE',
  'https://' + provider + '/cdmi/' + space + '/' + directory + '/'
]

remove_dir_proc = subprocess.Popen(curl, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
remove_dir_proc.wait()

curl = [
  'curl',
  '-k',
  '-H', 'X-Auth-Token: ' + token,
  '-H', 'X-CDMI-Specification-Version: 1.1.1',
  '-H', 'Content-Type: application/cdmi-container',
  '-X', 'PUT',
  'https://' + provider + '/cdmi/' + space + '/' + directory + '/'
]
create_dir_proc = subprocess.Popen(curl, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
create_dir_proc.wait()

processes = []
processes_done_counter = 0
for source in [studies_dir, data_object_dir]:
  index = 0
  for (dirpath, _, filenames) in os.walk(source):
    for filename in filenames:
      path = dirpath + '/' + filename
      with open(path, 'r') as json_file:
        metadata = json_file.read()
        if len(metadata) < 100000:
          curl = [
            'curl',
            '-k',
            '-H', 'X-Auth-Token: ' + token,
            '-H', 'X-CDMI-Specification-Version: 1.1.1',
            '-H', 'Content-Type: application/cdmi-object',
            '-X', 'PUT',
            '-d', '{"metadata": {"onedata_json": ' + metadata + '}}',
            'https://' + provider + '/cdmi/' + space + '/' + directory + '/' + filename.replace(' ', '')
          ]
          processes.append(subprocess.Popen(curl, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL))
          if len(processes) == 1000:
            for proc in processes:
              proc.wait()
            processes_done_counter += 1000
            print(str(processes_done_counter) + ' curls done')
            processes = []
for proc in processes:
  proc.wait()
if len(processes) is not 0:
  processes_done_counter += len(processes)
  print(str(processes_done_counter) + ' curls done')
