#include <fstream>
#include <iostream>
#include <rados/librados.hpp>
#include <string>
#include <vector>

auto split(const std::string &s, char delim) {
    std::vector<std::string> toks;
    std::stringstream ss(s);
    std::string tok;
    while (std::getline(ss, tok, delim)) {
        toks.push_back(tok);
    }
    return toks;
}

int main(int argc, const char **argv) {
    /* Continued from previous C++ example, where cluster handle and
     * connection are established. First declare an I/O Context.
     */
    librados::Rados cluster;

    librados::IoCtx io_ctx;
    const char *pool_name = "kronika-bn";

    int ret = cluster.init2("client.onedata", "ceph", 0);
    if (ret < 0) {
        throw std::runtime_error{"Couldn't initialize the cluster handle."};
    }
    //ret = cluster.conf_set("mon host", "172.17.0.9");
    ret = cluster.conf_set("mon host", "10.4.5.47");
    if (ret < 0) {
        throw std::runtime_error{
            "Couldn't set monitor host configuration "
            "variable."};
    }

    ret = cluster.conf_set("key", "AQAxMB9iaV3UJRAARyqDJNJYVBNJOLY5SYwn3A==");
    if (ret < 0) {
        throw std::runtime_error{"Couldn't set key configuration variable."};
    }

    ret = cluster.connect();
    if (ret < 0) {
        throw std::runtime_error{"Couldn't connect to cluster."};
    }

    ret = cluster.ioctx_create(pool_name, io_ctx);
    if (ret < 0) {
        std::cerr << "Couldn't set up ioctx! error " << ret << std::endl;
        exit(EXIT_FAILURE);
    } else {
        std::cout << "Created an ioctx for the pool." << std::endl;
    }

    const auto MAX_OBJECT_SIZE = 16 * 1024 * 1024UL;

    // std::vector<uint8_t> data;
    std::string data;
    data.reserve(MAX_OBJECT_SIZE);

    std::cout << "Opening file " << argv[1] << std::endl;
    std::fstream file_list;
    file_list.open(argv[1], std::ios::in);
    std::string file;
    while (std::getline(file_list, file)) {
        auto toks = split(file, '/');
        if (toks.size() != 6) continue;

        const auto &file_id = toks[4];
        const auto &object_key = toks[5];

        std::cout << "Fetching object: " << file_id << " key: " << object_key
                  << '\n';

        librados::bufferlist bl;
        ret = io_ctx.read(file, bl, MAX_OBJECT_SIZE, 0);
        if (ret < 0) {
            std::cerr << "Couldn't read object error " << ret << std::endl;
            exit(EXIT_FAILURE);
        }
        data.assign(bl.c_str(), bl.c_str() + ret);
        // std::cout << "   Got " << ret << " bytes\n";
        data.resize(ret);

        std::ofstream out_file;
        if (toks[5] == "999999") {
            // Fetching new file
            out_file.open(file_id, std::ios::binary | std::ios::out);
        } else {
            // Appending to existing file
            out_file.open(file_id, std::ios::binary | std::ios::app);
        }

        out_file.write(data.c_str(), ret);
        out_file.close();
    }

    file_list.close();

    io_ctx.close();
    cluster.shutdown();
}

