#include <iostream>
#include <rados/librados.hpp>
#include <string>

int main(int argc, const char **argv) {
    /* Continued from previous C++ example, where cluster handle and
     * connection are established. First declare an I/O Context.
     */
    librados::Rados cluster;

    librados::IoCtx io_ctx;
    const char *pool_name = "kronika-bn";

    int ret = cluster.init2("client.onedata", "ceph", 0);
    if (ret < 0) {
        throw std::runtime_error{"Couldn't initialize the cluster handle."};
    }
    ret = cluster.conf_set("mon host", "10.4.5.47");
    if (ret < 0) {
        throw std::runtime_error{"Couldn't set monitor host configuration "
                      "variable."};
    }

    ret = cluster.conf_set("key", "AQAxMB9iaV3UJRAARyqDJNJYVBNJOLY5SYwn3A==");
    if (ret < 0) {
        throw std::runtime_error{"Couldn't set key configuration variable."};
    }

    ret = cluster.connect();
    if (ret < 0) {
        throw std::runtime_error{"Couldn't connect to cluster."};
    }

    ret = cluster.ioctx_create(pool_name, io_ctx);
    if (ret < 0) {
        std::cerr << "Couldn't set up ioctx! error " << ret << std::endl;
        exit(EXIT_FAILURE);
    } else {
        std::cout << "Created an ioctx for the pool." << std::endl;
    }

    auto it = io_ctx.nobjects_begin();
    for (; it != io_ctx.nobjects_end(); it++) {
        std::cout << it->get_oid() << std::endl;
    }

    io_ctx.close();
    cluster.shutdown();
}

