import sys
import os


import shutil
from pathlib import Path

paths_dir = 'local-media-paths-correct-batch-1'
data_dir = 'local-media'

try:
    counter = 0
    for line in sys.stdin:
        toks = line.rstrip().split()
        if len(toks) != 2:
            print(f"!!! INVALID OR END OF INPUT: {toks}")
            break
        #print(f'### {toks}')
        fileid = toks[0]
        path_str = toks[1]
        path = Path(paths_dir+"/"+path_str)

        #print(f'**** {path}')
        
        parent = Path(str(path.parent))
        parent.mkdir(parents=True, exist_ok=True)
        src = data_dir + '/' + fileid
        dest = Path(paths_dir+ '/' + path_str).absolute()

        #print(f'Generating link from {src} to {dest}')

        try:
            shutil.copy(src, dest)
        except:
            pass
            
        counter += 1
        if counter % 10000 == 0:
            print(f"Generated {counter} copies")

except EOFError:
   pass
