import sys
import os
import multiprocessing


import shutil
from pathlib import Path


paths = []
print(f"Reading input...")
try:
    counter = 0
    paths = [line.rstrip().split() for line in sys.stdin]
except EOFError:
    pass


def copy_file(toks):
    if len(toks) != 2:
        print(f"!!! INVALID OR END OF INPUT: {toks}")
        return

    paths_dir = 'local-media-paths-correct-batch-1'
    data_dir = 'local-media'
    
    fileid = toks[0]
    path_str = toks[1]
    
    path = Path(paths_dir+"/"+path_str)

    parent = Path(str(path.parent))
    parent.mkdir(parents=True, exist_ok=True)
    src = data_dir + '/' + fileid
    dest = Path(paths_dir+ '/' + path_str).absolute()

    try:
        shutil.copy(src, dest)
    except:
        pass
        

print(f"Starting copy...")
with multiprocessing.Pool(50) as pool:
    pool.map(copy_file, paths, 10);

print(f'Completed...')
