import sys
import os


from pathlib import Path

symlink_dir = 'local-media-paths-links-correct-batch-1'
data_dir = 'local-media'

try:
    counter = 0
    for line in sys.stdin:
        toks = line.rstrip().split()
        if len(toks) != 2:
            print(f"!!! INVALID OR END OF INPUT: {toks}")
            break
        #print(f'### {toks}')
        fileid = toks[0]
        path_str = toks[1]
        path = Path(symlink_dir+"/"+path_str)
        #print(f'**** {path}')
        parent = Path(str(path.parent))
        parent.mkdir(parents=True, exist_ok=True)
        src = data_dir+'/'+fileid
        dest = Path(symlink_dir+'/'+path_str).absolute()
        #print(f'Generating link from {src} to {dest}')

        try:
            os.link(src, dest)
        except:
            pass
            #if os.path.islink(dest):
            #    #os.remove(dest)
            #    os.symlink(src, dest)
            #else:
            #    raise
        
        counter += 1
        
        if counter == 100:
            print(f"Generated {counter} links")
            counter = 0
            break

except EOFError:
   pass
