#!/usr/bin/env python3

import requests
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(category=InsecureRequestWarning)

PROVIDER_HOSTNAME = 'wcss2.hub.konektom.pl'
SPACE_ID = '74d325fc6392036b2c896ba2aa755389ch9203'
ACCESS_TOKEN = 'MDAxZGxvY2F00aW9uIGh1Yi5rb25la3RvbS5wbAowMDZiaWRlbnRpZmllciAyL25tZC91c3ItZDhmMzhlNDQ5ZGQ00NTdlM2QzYTMyMWJkNTRlMDc4OWFjaDA4NGEvYWN00L2QwZGM00OGFjY2ZjN2U3MjgzYmUyZGExZjliNGZhYzY2Y2g3NTQwCjAwMTljaWQgaW500ZXJmYWNlID00gcmVzdAowMDE4Y2lkIHNlcnZpY2UgPSBvcHctKgowMDE2Y2lkIGRhdGEucmVhZG9ubHkKMDAyZnNpZ25hdHVyZSAj7f5h01DjMXUoEC12HpxhxWYeMok022vvCmf99MCi3d01Ao'


def build_rest_url(path_tokens):
    path = '/'.join(path_tokens)
    return 'https://{}/api/v3/oneprovider/{}'.format(PROVIDER_HOSTNAME, path)


def rest_request(function, path_tokens, query_params={}, extra_headers={}):
    response = function(
        build_rest_url(path_tokens),
        params=query_params,
        headers={'x-auth-token': ACCESS_TOKEN, **extra_headers},
        verify=False
    )

    # debug
    # print(response.request.url)
    # print(response.request.body)
    # print(response.request.headers)
    # print('')

    return response.json()


next_page_token = 'start'
session = requests.Session()

while next_page_token is not None:
    query_params = {}
    if next_page_token != 'start':
        query_params = {'token': next_page_token}

    response = rest_request(session.get, ['data', SPACE_ID, 'files'], query_params=query_params)
    next_page_token = response['nextPageToken']
    for file in response['files']:
        print(file['path'])
